<?php
	require 'include/lib.php';
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>พนักงานขาย</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<label for="">ชื่อพนักงานขาย</label>
							<input type="text" name="name" class="form-control" placeholder="ชื่อพนักงานขาย" value="<?=isset($_GET['name']) ? $_GET['name'] : '';?>">
							&emsp;
							<label for="">ชื่อเล่น</label>
							<input type="text" name="phone" class="form-control" placeholder="ชื่อเล่น" value="<?=isset($_GET['nickname']) ? $_GET['nickname'] : '';?>">
							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('salesman.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<table class="table table-hover b-table">
					<tr class="heading">
						<td class="center" colspan="5">
							<a href="<?=URL::to('salesman-create.php')?>">
								<button class="btn btn-success">
									<i class="fa fa-plus"></i>
									เพิ่มพนักงานขาย
								</button>
							</a>
						</td>
					</tr>
					<tr class="heading">
						<th width="15%">#</th>
						<th width="45%">ชื่อพนักงานขาย</th>
						<th width="15%">เลขประจำตัวผู้เสียภาษี</th>
						<th width="25%" colspan="2">แก้ไข / ลบ</th>
					</tr>
					<?php
						$datas = Salesman::lists();

						if(sizeof($datas) == 0) {
							echo '<tr class="heading">';
								echo '<td class="center" colspan="5">ไม่พบข้อมูลพนักงานขายในระบบ</td>';
							echo '</tr>';
						}
						else {
							$cnt = 0;
							foreach ($datas as $key => $data) {
								echo '<tr>';
									echo '<td class="center">'.++$cnt.'</td>';
									echo '<td>'.$data['title'].$data['firstname'].' '.$data['lastname'].'</td>';
									echo '<td>'.$data['nickname'].'</td>';
									echo '<td class="center" width="10%">
										<i class="fa fa-edit fa-button" 
											onclick="window.location=\''.URL::to('salesman-update.php?id='.$data['id']).'\'"
										>
										</i>
									</td>';
									echo '<td class="center" width="10%">
										<i class="fa fa-trash fa-button"
											onclick="requestDelete('.$data['id'].')"
										>
										</i>
									</td>';
								echo '</tr>';
							}
						}
					?>
					<tr class="heading">
						<td class="center" colspan="5">
							<a href="<?=URL::to('salesman-create.php')?>">
								<button class="btn btn-success">
									<i class="fa fa-plus"></i>
									เพิ่มพนักงานขาย
								</button>
							</a>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function requestDelete(id) {
			if(confirm('ลบข้อมูลพนักงานขาย ?')) {
				window.location = '<?=URL::to('salesman-delete.php?delete=true&id=')?>'+id;
			}
		}
	</script>
</body>
</html>