var DOCROOT = '/billing-system';

$(document).ready(function() {

});

$(document).scroll(function() {
	if($(document).scrollTop() > 0) {
		$('#logo-container, #logo').addClass('small');
	}
	else {
		$('#logo-container, #logo').removeClass('small');
	}
});

function handleBarcode(selector, barcode, callback) {
	$(selector).val(barcode);
	callback();
}

function previewBarcode(selector, value) {
	value = value.trim();
	if(value.length != 13) {
		$(selector).hide();
		removeAlert(selector + '-text');
		return false;
	}
	let pass = false;
	try {
		JsBarcode(selector, value, {
			format: 'EAN13',
			width: 2,
			height: 40,
			fontSize: 20,
			background: 'transparent'
		});
		$(selector).show();
		pass = true;
		removeAlert(selector + '-text');
	}
	catch(err) {
		$(selector).hide();

		inputAlert(selector + '-text', 'danger', 'รหัสสินค้าผิดพลาด');
		pass = false;
	}
	return pass;
}

function inputAlert(selector ,type, detail) {
	$(selector).parents('div.form-group').children('.b-alert').remove();
	$('<div class="b-alert alert alert-' + type + ' ">' + detail + '</div>').insertAfter(selector);
	$(selector).parents('div.form-group').addClass('has-'+(type=='danger' ? 'error' : type));
	$(selector).focus();
}

function removeAlert(selector) {
	$(selector).parents('div.form-group').children('.b-alert').remove();
	$(selector).parents('div.form-group').removeClass('has-error has-warning has-info has-success');
}

function glow(ele){
	$(ele).addClass('glow').delay(300).queue(function() {
		$(ele).removeClass('glow').dequeue();
	});
}

function number_format(number, p = 0) {
	let formatter = new Intl.NumberFormat('en-US', {
		style: 'currency',
		currency: 'ABC',
		minimumFractionDigits: p,
	});

	return formatter.format(number).replace('ABC', '');
}

function generateBarcode() {
	let barcode = ('' + Math.random()).substring(2,15);
	let pad = '0000000000000'.substring(0, 13-barcode.length);
	barcode += pad;
	if(validateBarcode(barcode)) {
		return barcode;
	}

	for(i = 0, num = parseInt(barcode.substring(12, 13)); i < 10; i++) {
		num = num == 9 ? 0 : num + 1;
		barcode = barcode.substring(0, 12) + num;
		if(validateBarcode(barcode)) {
			return barcode;
		}
	}

	return barcode;
}

function validateBarcode(barcode) {
	var checkSum = barcode.split('').reduce(function(p, v, i) {
		return i % 2 == 0 ? p + 1 * v : p + 3 * v;
	}, 0);
	if (checkSum % 10 != 0) {
		return false;
	}
	return true;
}
