<?php
class Bill {
	const TABLE_NAME = 'bill';

	const FIELDS = [
		'discount' => [
			'type' => 'number',
			'required' => true,
			'default' => 0,
		],
		'discount_type' => [
			'type' => 'string',
			'required' => false,
			'default' => 'baht',
		],
		'invoiced' => [
			'type' => 'bool',
			'required' => false,
			'default' => false,
		],
		'remark' => [
			'type' => 'string',
			'required' => false,
		],
		'tax_value' => [
			'type' => 'number',
			'required' => true,
			'default' => 0,
		],
		'total' => [
			'type' => 'number',
			'required' => true,
			'default' => 0,
		],
		'sequence' => [
			'type' => 'number',
			'required' => true,
		],
		'customer_id' => [
			'type' => 'number',
			'required' => true,
		],
		// 'customer_name' => [
		// 	'type' => 'string',
		// 	'required' => true,
		// ],
		// 'customer_nickname' => [
		// 	'type' => 'string',
		// 	'required' => true,
		// ],
		// 'customer_address' => [
		// 	'type' => 'string',
		// 	'required' => false,
		// ],
		// 'customer_phone' => [
		// 	'type' => 'string',
		// 	'required' => false,
		// ],
		// 'customer_mobile' => [
		// 	'type' => 'string',
		// 	'required' => false,
		// ],
		'salesman_title' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_firstname' => [
			'type' => 'string',
			'required' => true,
		],
		'salesman_lastname' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_nickname' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_address' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_phone' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_mobile' => [
			'type' => 'string',
			'required' => false,
		],
		'salesman_fax' => [
			'type' => 'string',
			'required' => false,
		],
	];

	public static function create() {
		// if(!self::validate()) {
		// 	return [
		// 		'error' => true,
		// 		'result' => 'invalid'
		// 	];
		// }
		$addition_datas = [];

		// if(isset($_POST['new-customer']) && $_POST['new-customer'] == 'on') {
		// 	$salesman = [
		// 		'salesman_title' => isset($_POST['salesman-title']) ? DB::escape($_POST['salesman-title']) : '',
		// 		'salesman_firstname' => isset($_POST['salesman-firstname']) ? DB::escape($_POST['salesman-firstname']) : '',
		// 		'salesman_lastname' => isset($_POST['salesman-lastname']) ? DB::escape($_POST['salesman-lastname']) : '',
		// 		'salesman_nickname' => isset($_POST['salesman-nickname']) ? DB::escape($_POST['salesman-nickname']) : '',
		// 		'salesman_address' => isset($_POST['salesman-address']) ? DB::escape($_POST['salesman-address']) : '',
		// 		'salesman_phone' => isset($_POST['salesman-phone']) ? DB::escape($_POST['salesman-phone']) : '',
		// 		'salesman_mobile' => isset($_POST['salesman-mobile']) ? DB::escape($_POST['salesman-mobile']) : '',
		// 		'salesman_fax' => isset($_POST['salesman-fax']) ? DB::escape($_POST['salesman-fax']) : '',
		// 	];

		// 	$addition_datas = array_merge($addition_datas, $salesman);
		// }
		// else if(isset($_POST['salesman-id']) && intval($_POST['salesman-id'])) {

		$salesman = DB::query('SELECT title, firstname, lastname, nickname, address, phone, mobile, fax FROM salesman WHERE id = {id}', [
			'id' => intval($_POST['salesman-id']),
		]);
		$salesman = $salesman[0];
		foreach ($salesman as $key => $value) {
			$salesman['salesman_'.$key] = $value;
			unset($salesman[$key]);
		}

		$addition_datas = array_merge($addition_datas, $salesman);

		$sequence = DB::query('SELECT (IFNULL(COUNT(1),0) + 1) AS sequence FROM bill WHERE customer_id = {customer_id} AND invoiced = 0', [
			'customer_id' => intval($_POST['customer-id']),
		]);
		$sequence = $sequence[0];

		$addition_datas = array_merge($addition_datas, $sequence);

		// }

		// if(isset($_POST['new-customer']) && $_POST['new-customer'] == 'on') {
		// 	$customer = [
		// 		'customer_name' => isset($_POST['customer-name']) ? DB::escape($_POST['customer-name']) : '',
		// 		'customer_nickname' => isset($_POST['customer-nickname']) ? DB::escape($_POST['customer-nickname']) : '',
		// 		'customer_address' => isset($_POST['customer-address']) ? DB::escape($_POST['customer-address']) : '',
		// 		'customer_phone' => isset($_POST['customer-phone']) ? DB::escape($_POST['customer-phone']) : '',
		// 		'customer_mobile' => isset($_POST['customer-mobile']) ? DB::escape($_POST['customer-mobile']) : '',
		// 	];
		//
		// 	DB::execute('INSERT INTO customer(name, nickname, address, phone, mobile) VALUES("{name}", "{nickname}", "{address}", "{phone}", "{mobile}")', [
		// 		'name' => isset($_POST['customer-name']) ? DB::escape($_POST['customer-name']) : '',
		// 		'nickname' => isset($_POST['customer-nickname']) ? DB::escape($_POST['customer-nickname']) : '',
		// 		'address' => isset($_POST['customer-address']) ? DB::escape($_POST['customer-address']) : '',
		// 		'phone' => isset($_POST['customer-phone']) ? DB::escape($_POST['customer-phone']) : '',
		// 		'mobile' => isset($_POST['customer-mobile']) ? DB::escape($_POST['customer-mobile']) : '',
		// 	]);
		//
		// 	$addition_datas = array_merge($addition_datas, $customer);
		//
		// }
		// else {
		// $customer = DB::query('SELECT id, name, nickname, address, phone, mobile FROM customer WHERE id = {id}', [
		// 	'id' => intval($_POST['customer-id']),
		// ]);
		// $customer = $customer[0];
		//
		// foreach ($customer as $key => $value) {
		// 	$customer['customer_'.$key] = $value;
		// 	unset($customer[$key]);
		// }
		//
		// $addition_datas = array_merge($addition_datas, $customer);
		// }

		// var_dump($addition_datas);

		$customer = Customer::detail($_POST['customer-id']);
		$_POST['tax-value'] = $customer['tax_value'];
		// if(!isset($_POST['tax'])) {
		// 	$_POST['tax-value'] = 0;
		// }

		if(!isset($_POST['discount-type'])) {
			$_POST['discount-type'] = 'percentage';
		}
		else {
			$_POST['discount-type'] = 'baht';
		}

		DB::execute('BEGIN');

		$result = DB::execute('INSERT INTO {table} ('.Validator::get_insert_field_string(self::FIELDS).') VALUES ('.Validator::get_insert_data_string(self::FIELDS, 'post', $addition_datas).')', [
			'table' => self::TABLE_NAME,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'insert_bill_error'
			];
		}

		$id = DB::get_last_id();

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'insert_bill_error'
			];
		}

		$cnt = 0;
		$total = 0;
		foreach ($_POST['product'] as $barcode => $product) {
			$item = DB::query('SELECT * FROM product WHERE barcode LIKE "{barcode}"', [
				'barcode' => $barcode,
			]);

			if(sizeof($item) < 1) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'product_not_found'
				];
			}

			$item = $item[0];

			$bill_detail = DB::execute('INSERT INTO bill_detail (bill_id, sequence, product_name, product_description, product_barcode, product_price, product_quantity)
			VALUES ({bill_id}, {sequence}, "{product_name}", "{product_description}", "{product_barcode}", {product_price}, {product_quantity})', [
				'bill_id' => $id,
				'sequence' => (++$cnt),
				'product_name' => $item['name'],
				'product_description' => $item['description'],
				'product_barcode' => $item['barcode'],
				'product_price' => $item['price'],
				'product_quantity' => intval($product)
			]);

			$total += ($item['price']*intval($product));

			if(!$bill_detail) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'insert_bill_detail_error'
				];
			}
		}

		$discount = floatval($_POST['discount']);

		if($_POST['discount-type'] == 'percentage') {
			$total -= ($total*($discount/100));
		}
		else {
			$total -= $discount;
		}

		// if(isset($_POST['tax'])) {
		// 	$total += ($total*(floatval($_POST['tax-value'])/100));
		// }

		$bill_update = DB::execute('UPDATE bill SET total = {total} WHERE id = {id}', [
			'total' => $total,
			'id' => $id
		]);

		if(!$bill_update) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'update_bill_error'
			];
		}

		DB::execute('COMMIT');

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function update($id) {
		$id = intval($id);

		if(!isset($_POST['tax'])) {
			$_POST['tax-value'] = 0;
		}

		if(!isset($_POST['discount-type'])) {
			$_POST['discount-type'] = 'percentage';
		}
		else {
			$_POST['discount-type'] = 'baht';
		}

		DB::execute('BEGIN');

		$result = DB::execute('UPDATE {table} SET '.Validator::get_update_data_string(self::FIELDS, 'post').' WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'update_bill_error'
			];
		}

		//////////////////////////////////////////////////////////////////////

		$cnt = 0;
		$total = 0;
		foreach ($_POST['product'] as $barcode => $product) {
			if(!isset($product['bill-id']) || intval($product['bill-id']) <= 0 || !isset($product['sequence']) || intval($product['sequence']) <= 0) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'bill_id_sequence_error'
				];
			}

			$bill_id = intval($product['bill-id']);
			$seq = intval($product['sequence']);

			$bill_detail = DB::execute('UPDATE bill_detail
			SET product_price = {product_price}, product_quantity = {product_quantity}
			WHERE bill_id = {bill_id} AND sequence = {sequence}', [
				'bill_id' => $bill_id,
				'sequence' => $seq,
				'product_price' => floatval($product['price']),
				'product_quantity' => intval($product['quantity'])
			]);

			$total += (floatval($product['price'])*intval($product['quantity']));

			if(!$bill_detail) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'update_bill_detail_error'
				];
			}
		}

		$discount = floatval($_POST['discount']);

		if($_POST['discount-type'] == 'percentage') {
			$total -= ($total*($discount/100));
		}
		else {
			$total -= $discount;
		}

		// if(isset($_POST['tax'])) {
		// 	$total += ($total*(floatval($_POST['tax-value'])/100));
		// }

		$bill_update = DB::execute('UPDATE {table} SET total = {total} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'total' => $total,
			'id' => $id
		]);

		if(!$bill_update) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'update_bill_error'
			];
		}

		//////////////////////////////////////////////////////////////////////

		DB::execute('UPDATE {table} SET updated_at = NOW() WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'update_bill_error'
			];
		}

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'bill_notfound'
			];
		}

		DB::execute('COMMIT');

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function delete($id) {
		$id = intval($id);

		DB::execute('BEGIN');

		$delete_bill = DB::execute('DELETE FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		$delete_bill_detail = DB::execute('DELETE FROM {table} WHERE bill_id = {id}', [
			'table' => 'bill_detail',
			'id' => $id,
		]);

		if(!$delete_bill || !$delete_bill_detail) {
			DB::execute('ROLLBACK');
			return false;
		}

		DB::execute('COMMIT');

		return $delete_bill;
	}

	public static function detail($id) {
		$id = intval($id);

		$result = DB::query('SELECT *
			FROM {table}
			WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		return sizeof($result) == 0 ? false : $result[0];
	}

	public static function lists($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_invoice = ' invoiced = 0 ';
		$filter_date = '';
		$filter_tax = ' AND 1 ';
		$filter_customer = '';

		if(isset($_GET['date-from']) && trim($_GET['date-from']) != '') {
			$filter_date = 'AND DATE(created_at) >= DATE("'.trim($_GET['date-from']).'")';
		}else if(isset($_GET['date-to']) && trim($_GET['date-to']) != '') {
			$filter_date = 'AND DATE(created_at) <= DATE("'.trim($_GET['date-to']).'")';
		}

		if(isset($_GET['date-from']) && trim($_GET['date-from']) != '' && isset($_GET['date-to']) && trim($_GET['date-to']) != ''){
			$filter_date = 'AND (DATE(created_at) BETWEEN DATE("'.trim($_GET['date-from']).'") AND DATE("'.trim($_GET['date-to']).'") )';
		}

		if(isset($_GET['tax'])) {
			$tax = trim($_GET['tax']);
			if($tax == 'tax') {
				$filter_tax = ' AND tax_value > 0 ';
			}
			else if($tax == 'notax') {
				$filter_tax = ' AND tax_value = 0 ';
			}

		}

		if(isset($_POST['invoice_id']) && intval($_POST['invoice_id']) > 0) {
			$filter_invoice = ' invoiced = '.intval($_POST['invoice_id']);

			if(isset($_GET['date-from']) || isset($_GET['date-to']) || isset($_GET['tax'])) {
				$filter_invoice .= ' OR invoiced = 0';
			}
		}

		if(isset($_GET['customer-id']) && intval($_GET['customer-id']) > 0) {
			$filter_customer = ' AND customer_id = '.intval($_GET['customer-id']);
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_invoice.' '.$filter_date.' '.$filter_tax.' '.$filter_customer.' ORDER BY created_at', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function validate() {
		return Validator::validate(self::FIELDS, 'post');
	}
}

class BillDetail {
	public static function delete($bill_id, $seq) {
		$bill_id = intval($bill_id);
		$seq = intval($seq);

		$bill = Bill::detail($bill_id);
		$bill_details = DB::query('SELECT bill_id, sequence, product_price, product_quantity FROM bill_detail WHERE bill_id = {bill_id} AND sequence != {seq}', [
			'bill_id' => $bill_id,
			'seq' => $seq
		]);

		if(!$bill || !$bill_details) {
			return false;
		}

		////////////////////////////////////////////////////////////
		$total = 0;
		foreach ($bill_details as $key => $bill_detail) {
			if(!isset($bill_detail['bill_id']) || intval($bill_detail['bill_id']) <= 0 || !isset($bill_detail['sequence']) || intval($bill_detail['sequence']) <= 0) {
				return false;
			}

			$total += (floatval($bill_detail['product_price'])*intval($bill_detail['product_quantity']));
		}

		$discount = floatval($bill['discount']);

		if($bill['discount_type'] == 'percentage') {
			$total -= ($total*($discount/100));
		}
		else {
			$total -= $discount;
		}

		if(floatval($bill['tax_value']) > 0) {
			$total += ($total*(floatval($bill['tax_value'])/100));
		}

		DB::execute('BEGIN');

		$bill_update = DB::execute('UPDATE {table} SET total = {total} WHERE id = {id}', [
			'table' => 'bill',
			'total' => $total,
			'id' => $bill['id']
		]);

		if(!$bill_update) {
			DB::execute('ROLLBACK');
			return false;
		}

		$bill_detail_delete = DB::execute('DELETE FROM {table} WHERE bill_id = {bill_id} AND sequence = {seq}', [
			'table' => 'bill_detail',
			'bill_id' => $bill['id'],
			'seq' => $seq,
		]);

		if(!$bill_detail_delete) {
			DB::execute('ROLLBACK');
			return false;
		}

		DB::execute('COMMIT');

		return $bill_detail_delete;
	}
}
// HTML::pre(Bill::create());

// HTML::pre(Bill::validate());

// var_dump(Validator::get_insert_data_string(Bill::FIELDS, 'post'));

// Bill::create();
?>
