<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('customer.php');
	}

	$id = intval($_GET['id']);

	if(isset($_POST['submit']) && $_POST['submit'] == 'customer') {
		if(isset($_POST['method']) && $_POST['method'] == 'update') {
			$result = Customer::update($id);
		}
	}

	$data = Customer::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('customer.php');
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>แก้ไขข้อมูลลูกค้า</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6" style="margin: auto; float: none;">
					<div class="panel panel-warning">
						<div class="panel-body">
							<form method="post">
								<input type="hidden" name="submit" value="customer" />
								<input type="hidden" name="method" value="update" />
								<input type="hidden" name="customer-id" value="<?=$id;?>" />
								<div class="form-group">
									<label for="">ชื่อ *</label>
									<textarea name="name" class="form-control" id="" cols="30" rows="5" placeholder="ชื่อ" style="resize: none;" required><?=isset($data['name']) ? $data['name'] : '';?></textarea>
								</div>
								<div class="form-group">
									<label for="">สาขา *</label>
									<input name="nickname" class="form-control" type="text" placeholder="สาขา" value="<?=isset($data['nickname']) ? $data['nickname'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">ที่อยู่</label>
									<textarea name="address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;"><?=isset($data['address']) ? trim($data['address']) : '';?></textarea>
								</div>
								<div class="form-group">
									<label for="">ภาษี</label>
								</div>
								<div class="form-group center">
									<input id="tax" name="tax" type="checkbox" data-toggle="toggle" data-style="tax" data-on="คิดภาษี" data-off="ไม่คิดภาษี" data-onstyle="danger" style="display: inline-block;" <?=($data['tax_value'] > 0 ? 'checked' : '');?> />
									<input id="tax-value" name="tax-value" class="form-control right number" type="number" min="0.00" value="<?=($data['tax_value']==0 ? 7 : ($data['tax_value'] % 1 == 0 ? intval($data['tax_value']) : $data['tax_value']));?>" style="display: inline-block; width: 20%;" /> %
								</div>
								<!-- <div class="form-group">
									<label for="">โทรศัพท์</label>
									<input name="phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($data['phone']) ? $data['phone'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">มือถือ</label>
									<input name="mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($data['mobile']) ? $data['mobile'] : '';?>"/>
								</div> -->
								<div class="form-group center">
									<button type="reset" class="btn btn-warning">
										<i class="fa fa-undo"></i>
										ล้าง
									</button>
									<button type="submit" class="btn btn-success">
										<i class="fa fa-plus"></i>
										แก้ไขข้อมูลลูกค้า
									</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
		if(isset($result)) {
			if(!$result['error']) {
				echo HTML::inputAlert('textarea[name="name"]', 'success', 'แก้ไขข้อมูลลูกค้าสำเร็จ');
			}
		}
	?>
</body>
</html>
